<xsl:stylesheet version="1.0"
     xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
     xmlns:msxsl="urn:schemas-microsoft-com:xslt"
>

<xsl:output method="html" indent="yes" version="4.0"/>


<!-- ********************************************************************* -->
<!-- **************************  MAIN   ********************************** -->
<!-- ********************************************************************* -->
<!-- ********************************************************************* -->
<xsl:template match="TXFFileList">
	<xmlDIALOG>
	   <LISTGRID id="TXFFileList" width='483' height='100' select='kSingle'>
	   <LISTGRIDHROW>
	      <LISTGRIDHCOL width='240'>File Name</LISTGRIDHCOL>
	      <LISTGRIDHCOL width='80'>Date</LISTGRIDHCOL>
	      <LISTGRIDHCOL width='112'>Source</LISTGRIDHCOL>
	   </LISTGRIDHROW>
      <xsl:apply-templates />
      </LISTGRID>
	</xmlDIALOG>
</xsl:template>

<!-- ********************************************************************* -->
<xsl:template match="TXFFile">
	<LISTGRIDBROW event="TXFFileSelected">
	   <xsl:if test="string(@default)='true'">
         <xsl:attribute name="checked">
            <xsl:value-of select="@default"/>
         </xsl:attribute>
      </xsl:if>
      <xsl:attribute name="value">
         <xsl:value-of select="@PathFileName"/>
      </xsl:attribute>
   	<xsl:apply-templates />
   	<xsl:attribute name="id">
   	   <xsl:text>kTXFFile</xsl:text>
         <xsl:value-of select="position()"/>
   	</xsl:attribute>
      <BIND source="TXFFileList" target="TXFSelectedFile"/>
   	<LISTGRIDBCOL><xsl:value-of select="@FileName"/></LISTGRIDBCOL>
   	<LISTGRIDBCOL><xsl:value-of select="@FileDate"/></LISTGRIDBCOL>
   	<LISTGRIDBCOL><xsl:value-of select="@FileSource"/></LISTGRIDBCOL>
	</LISTGRIDBROW>
</xsl:template>

</xsl:stylesheet>




